# emacs-mode: -*- python-*-
import ability.utility as Utility
import random
import traceback
from ability.defines import *
import stringtable_client as StringTable
VIRII_LEVEL_1_DURATION = 10.0
VIRII_LEVEL_2_DURATION = 15.0
VIRII_LEVEL_3_DURATION = 25.0
VIRII_MULTI_DURATION = VIRII_LEVEL_3_DURATION
VIRII_LEVEL_1_DEBUFF = -10
VIRII_LEVEL_2_DEBUFF = -20
VIRII_LEVEL_3_DEBUFF = -30
VIRII_LEVEL_1_BUFF = 10
VIRII_LEVEL_2_BUFF = 20
VIRII_LEVEL_3_BUFF = 30
VIRII_LEVEL_1_RANGE = 5000.0
VIRII_LEVEL_2_RANGE = 5000.0
VIRII_LEVEL_3_RANGE = 5000.0

def SendVirusResultToAll(result, virus, subject, directobject, send_message = True, exValues = ()):
    if (send_message == False):
        return 
    if (result == SUCCESS):
        Utility.SendAbilityOutputToAll(StringTable.ID_CLIENT_ABILITY_VIRUS_HIT, virus, subject, directobject, exValues)
    elif (result == DEFLECTED):
        Utility.SendAbilityOutputToAll(StringTable.ID_CLIENT_ABILITY_VIRUS_DEFLECTED, virus, subject, directobject, exValues)
    elif (result == REFLECTED):
        Utility.SendAbilityOutputToAll(StringTable.ID_CLIENT_ABILITY_VIRUS_REFLECTED, virus, subject, directobject, exValues)



def VirusSuccessCheck(sentence, virus, vaccination, allow_success_msg = False):
    if (ProgramLauncherCheck(sentence.subject) == FAILURE):
        Utility.SendAbilityOutputToCasterSentence(StringTable.ID_CLIENT_ABILITY_PROGRAM_LAUNCHER_NOT_EQUIPPED, virus, sentence)
        return (FAILURE,
         0)
    if (VaccinationCheck(sentence.directObject, vaccination) == DEFLECTED):
        vaccination_name_id = Utility.GetAbilityInfoID(vaccination)
        Utility.SendAbilityOutputToAll(StringTable.ID_CLIENT_ABILITY_VIRUS_VACCINATED, virus, sentence.subject.locator, sentence.directObject.locator, vaccination_name_id)
        return (DEFLECTED,
         0)
    difficultyRating = CalcDifficultyValue(sentence.directObject)
    successChance = SingleSuccessRating(sentence.subject)
    return DifficultyCheck(virus, sentence.subject.locator, sentence.directObject.locator, successChance, difficultyRating, allow_success_msg)



def ProgramLauncherCheck(player):
    if (Utility.IsProgramLauncherEquipped(player) == FAILURE):
        return FAILURE
    return SUCCESS



def VaccinationCheck(player, vaccination):
    if vaccination:
        if player.hasAbility[vaccination]:
            Utility.outputAbilityDebug('VaccinationCheck: Player deflected due to vaccinate!')
            return DEFLECTED
    return SUCCESS



def ReflectionCheck(subject, reflection):
    if subject.hasAbility[reflection]:
        randomRoll = random.randrange(100)
        if subject.hasAbility[HackerAbility]:
            if (subject.abilities[HackerAbility] >= randomRoll):
                Utility.outputAbilityDebug('Relection Check : virus reflected! ')
                return REFLECTED
    return SUCCESS



def CalcDifficultyValue(player):
    difficulty = player.Level
    if (player.abilities[ResistVirusesAbility] > difficulty):
        difficulty = player.abilities[ResistVirusesAbility]
    difficulty += 50
    difficulty = (50 + (4 * (Utility.Get_HPAL_Level(player) + player.abilities[ResistVirusesAbility])))
    return difficulty



def CalcSuccessRating(player):
    success_chance = (4 * (TransmitVirus + ExecuteProgram))
    success_chance = player.abilities[TransmitVirusAbility]
    if player.abilities[ExecuteProgramAbility]:
        success_chance += player.abilities[ExecuteProgramAbility]
    success_chance *= 4
    return success_chance



def SingleSuccessRating(player):
    success_chance = CalcSuccessRating(player)
    success_chance += random.randrange(100)
    return success_chance



def MultiSuccessRating(player):
    return CalcSuccessRating(player)



def DifficultyCheck(virus, subjectLocator, directobjectLocator, success_chance, difficulty_rating, allow_success_msg):
    diff = (success_chance - difficulty_rating)
    if (diff > 0):
        SendVirusResultToAll(SUCCESS, virus, subjectLocator, directobjectLocator, allow_success_msg, diff)
        Utility.outputAbilityDebug(('DifficultyCheck: SUCCEEDED: %d > %d' % (success_chance,
         difficulty_rating)))
        return (SUCCESS,
         diff)
    else:
        SendVirusResultToAll(FAILURE, virus, subjectLocator, directobjectLocator, allow_success_msg, diff)
        Utility.outputAbilityDebug(('DifficultyCheck: DEFLECTED: %d > %d' % (success_chance,
         difficulty_rating)))
        return (DEFLECTED,
         diff)



def MultiDifficultyCheck(virus, vaccination, subjectLocator, directobject, success_chance, difficulty_rating, allow_success_msg = True):
    if (VaccinationCheck(directobject, vaccination) == DEFLECTED):
        vaccination_name_id = Utility.GetAbilityInfoID(vaccination)
        if allow_success_msg:
            Utility.SendAbilityOutputToAll(StringTable.ID_CLIENT_ABILITY_VIRUS_VACCINATED, virus, subjectLocator, directobject.locator, vaccination_name_id)
        return (DEFLECTED,
         0)
    success_chance += random.randrange(100)
    return DifficultyCheck(virus, subjectLocator, directobject.locator, success_chance, difficulty_rating, allow_success_msg)



def MultVirusSuccessCheck(sentence, virus, vaccination):
    if (ProgramLauncherCheck(sentence.subject) == FAILURE):
        Utility.SendAbilityOutputToCasterSentence(StringTable.ID_CLIENT_ABILITY_PROGRAM_LAUNCHER_NOT_EQUIPPED, virus, sentence)
        sentence.result = FAILURE
        return (FAILURE,
         0)
    sentence.result = MultiSuccessRating(sentence.subject)
    return (SUCCESS,
     0)



# local variables:
# tab-width: 4
