# emacs-mode: -*- python-*-
import traceback
import obj
import ability.utility as Utility
SMG_SUPPRESSION_FIRE_DAMAGE = 75
SMG_FULL_AUTO_DAMAGE = 250
SMG_FULL_AUTO_REDUX_DAMAGE = 300
SMG_HEAVING_VOLLEY_DAMAGE = 215
SMG_SLIDING_VOLLEY_DAMAGE = 100
SMG_CONTROLLED_BURST_DAMAGE = 90
SMG_SUPPRESSION_FIRE_POWERLESS_EFFECT_DURATION = 15

def SubmachineGunSuppressionFire_DirectObject(subject, msg):
    Utility.outputAbilityDebug(('SubmachineGunSuppressionFire: %d damage dealt' % SMG_SUPPRESSION_FIRE_DAMAGE))
    damage = subject.Interlock.physicalDamageFromAbility(msg.subjectLocator, SMG_SUPPRESSION_FIRE_DAMAGE)
    Utility.SendTakeDamageResultToAll(SUCCESS, SubmachineGunSuppressionFireAbility, msg.subjectLocator, msg.directObjectLocator, damage)



def SubmachineGunSuppressionFire_Subject(subject, msg):
    Utility.outputAbilityDebug('SubmachineGunSuppressionFire: Subject')



def SubmachineGunCoveringFire_DirectObject(subject, msg):
    Utility.outputAbilityDebug('SubmachineGunCoveringFire: opponent forced to ground for 2 exchanges')



def SubmachineGunFullAuto_DirectObject(subject, msg):
    Utility.outputAbilityDebug(('SubmachineGunFullAuto: %d damage dealt' % SMG_FULL_AUTO_DAMAGE))
    damage = subject.Interlock.physicalDamageFromAbility(msg.subjectLocator, SMG_FULL_AUTO_DAMAGE)
    Utility.SendTakeDamageResultToAll(SUCCESS, SubmachineGunFullAutoAbility, msg.subjectLocator, msg.directObjectLocator, damage)



def SubmachineGunFullAutoRedux_DirectObject(subject, msg):
    Utility.outputAbilityDebug(('SubmachineGunFullAutoRedux: %d damage dealt' % SMG_FULL_AUTO_REDUX_DAMAGE))
    damage = subject.Interlock.physicalDamageFromAbility(msg.subjectLocator, SMG_FULL_AUTO_REDUX_DAMAGE)
    Utility.SendTakeDamageResultToAll(SUCCESS, SubmachineGunFullAutoReduxAbility, msg.subjectLocator, msg.directObjectLocator, damage)



def SubmachineGunHeavingVolley_DirectObject(subject, msg):
    Utility.outputAbilityDebug(('SubmachineGunHeavingVolley: %d damage dealt' % SMG_HEAVING_VOLLEY_DAMAGE))
    damage = subject.Interlock.physicalDamageFromAbility(msg.subjectLocator, SMG_HEAVING_VOLLEY_DAMAGE)
    Utility.SendTakeDamageResultToAll(SUCCESS, SubmachineGunHeavingVolleyAbility, msg.subjectLocator, msg.directObjectLocator, damage)



def SubmachineGunSlidingVolley_DirectObject(subject, msg):
    Utility.outputAbilityDebug(('SubmachineGunSlidingVolley: %d damage dealt' % SMG_SLIDING_VOLLEY_DAMAGE))
    damage = subject.Interlock.physicalDamageFromAbility(msg.subjectLocator, SMG_SLIDING_VOLLEY_DAMAGE)
    Utility.SendTakeDamageResultToAll(SUCCESS, SubmachineGunSlidingVolleyAbility, msg.subjectLocator, msg.directObjectLocator, damage)



def SubmachineGunControlledBurst_DirectObject(subject, msg):
    Utility.outputAbilityDebug(('SubmachineGunControlledBurst: %d damage dealt' % SMG_CONTROLLED_BURST_DAMAGE))
    damage = subject.Interlock.physicalDamageFromAbility(msg.subjectLocator, SMG_CONTROLLED_BURST_DAMAGE)
    Utility.SendTakeDamageResultToAll(SUCCESS, SubmachineGunControlledBurstAbility, msg.subjectLocator, msg.directObjectLocator, damage)



# local variables:
# tab-width: 4
