# emacs-mode: -*- python-*-
import random
import traceback
import obj
import missionvalidate as mv

def DistanceWithin(pos1, pos2, dist):
    """ Returns true if the vectors pos1 and pos2 have a distance of less than dist. """
    x_diff = (pos1.x - pos2.x)
    y_diff = (pos1.y - pos2.y)
    z_diff = (pos1.z - pos2.z)
    return ((((x_diff * x_diff) + (y_diff * y_diff)) + (z_diff * z_diff)) < (dist * dist))



def CombatPhysicsOkay(subject, directObject, rangeValue = 700):
    pos1 = subject.Position
    pos2 = directObject.Position
    if (not DistanceWithin(pos1, pos2, rangeValue)):
        return False
    if (not physics.clearLine(pos1, pos2)):
        return False
    return True



def CanFight(subject, directObject):
    '\n    This rule should become quite complex as it tries to figure\n\tout if anyone can fight anything.\n\t\n\tNope, all the complexity is buried in CharMvt.isEnemy.\n    '
    if (directObject.IsDead or subject.IsDead):
        return False
    if (not subject.CharMvt.isEnemy(directObject.locator)):
        return False
    if (not CombatPhysicsOkay(subject, directObject)):
        return False
    return True


CanFight.depAttr = '\ndirectObject.IsDead\ndirectObject.Position\ndirectObject.locator\n'

# local variables:
# tab-width: 4
